% ALPHA ENGINE DEFINITION
% Generated 29-Jul-2020 12:41:05

% SUGGESTED CITATION:
% 2018 Toyota 2.5L A25A-FKS Engine Tier 3 Fuel - ALPHA Map Package. Version 2020-07. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2020.


% Constructor
engine = class_REVS_engine();
engine.name =  '2018 Toyota 2.5L A25A-FKS Engine Tier 3 Fuel'; 
engine.source_filename = mfilename;engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  2.487; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  13; 
engine.bore_mm =  87.5; 
engine.stroke_mm =  103.4; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	    0.00000000000000000	;     84.508842381565429	;     104.06526760511444	;     105.06526760511444	;     120.99844105301089	;     139.00670110402751	;     157.05114274611151	;     181.15851237259469	;     211.38998280647132	;     265.49125312822645	;     313.85974433895962	;     423.00797082335708	;     470.84970760835927	;     523.59877559829886	;     691.15038378975441	;     725.70790297924214	;     760.26542216872997		]; 
engine.full_throttle_torque_Nm = [	    0.00000000000000000	;     108.20000000000000	;     133.43199071616763	;     158.37904191616764	;     180.67999999999998	;     186.56054054054047	;     194.83088235294122	;     198.77272727272725	;     212.66820512820510	;     220.42264150943393	;     219.29032258064515	;     233.80952380952388	;     236.01546391752564	;     249.47051199999999	;     219.02551316964789	;     187.73615414541248	;    0.00000000000000000		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	    0.00000000000000000	;     138.85839528866885	;     265.46457922833753	;     373.95424553230504	;     518.78166686279451	;     760.26542216872997		]; 
engine.closed_throttle_torque_Nm = [	    -15.809481808158766	;    -22.899999999999999	;    -25.899999999999999	;    -30.600000000000001	;    -42.299999999999997	;    -54.630871003307611		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	    0.00000000000000000	;     40.762164680327558	;     81.524329360655116	;     117.50576634052098	;     138.86333881584747	;     156.96349128441210	;     181.06021860244829	;     211.23458327916586	;     265.46934230094655	;     313.74723459107747	;     374.05468341626522	;     422.28847961695163	;     470.53860674269447	;     518.79567960255429	;     567.04234327756308	;     603.42091616524067	;     681.84316916698526	;     760.26542216872997		]; 
engine.fuel_map_torque_Nm = [	    -57.362414553472995	;    -42.783707276736493	;    -28.204999999999998	;    -12.619166666666665	;     2.9666666666666668	;     12.718421052631580	;     28.766666666666666	;     40.812500000000000	;     54.439999999999998	;     63.635277777777773	;     72.830555555555549	;     88.879999999999995	;     103.90000000000001	;     114.67222222222222	;     128.53333333333333	;     135.84999999999999	;     149.44604316546761	;     159.71467160604487	;     169.98330004662211	;     180.67999999999998	;     185.18837837837836	;     196.89281344454776	;     209.67081272319996	;     225.33823245652508	;     243.64113502826254	;     261.94403760000000		]; 
engine.fuel_map_gps = [
   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	;
   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	  0.075518802205716051	   0.14437071085240241	   0.29170305316180417	   0.43806559139141926	;
   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	  0.046884204432192302	   0.12530989919656543	   0.22941155082336931	   0.36611160309842505	   0.50216791657841364	   0.60197486512241094	   0.81059750969056321	    1.0164888141337547	;
   0.00000000000000000	  0.029304605214868273	  0.062149436896392851	  0.086158908686558081	  0.099098338268550162	   0.11001226114027636	   0.12477597999748215	   0.14703828726280804	   0.20063001724110135	   0.26934558040764084	   0.37989850940676856	   0.49740245827835838	   0.63831940785790198	   0.79773875364498004	   0.96653477337084615	    1.0949211327614898	    1.3692916387024585	    1.6374428770296046	;
 0.0081591808105537910	  0.078142872742130318	   0.14859879294814068	   0.20656995988571417	   0.23556883224267816	   0.25982613716701863	   0.29277570361955818	   0.33752045879143133	   0.43274009037299571	   0.54081953045121844	   0.70881269081047604	   0.86765963993580641	    1.0456999128593962	    1.2400883221750731	    1.4452328280868205	    1.6018850289290010	    1.9367945239559008	    2.2637168043973994	;
  0.014480632746139305	  0.098068736487434402	   0.18199605613108383	   0.25471636477064324	   0.29895719531752496	   0.33659666850003150	   0.38621054966114010	   0.44898230246919935	   0.57347240586832604	   0.70680852870429078	   0.91159483590984625	    1.0964214166622372	    1.2949333589190699	    1.5152057340090472	    1.7494184276413300	    1.9253843180401253	    2.2962764800061937	    2.6597102415859566	;
  0.023645472029021196	   0.13170164995201503	   0.24122079652643955	   0.33714364236879507	   0.39833428481301769	   0.45223068566644764	   0.52490605998383810	   0.61583974709460620	   0.79721756363166330	   0.97116254153220327	    1.2377354696094995	    1.4684165745399493	    1.6929209793948210	    1.9606347701692561	    2.2552915680287131	    2.4630045256302791	    2.8945709494879508	    3.3217512077491698	;
  0.032971118104613915	   0.16177618597478324	   0.28943307609323210	   0.40556188376557556	   0.47935201951522194	   0.54307072679932866	   0.62918631758930299	   0.73959123115406300	   0.95434524435815982	    1.1684222173543095	    1.4675750083934933	    1.7271436442358192	    2.0016660122294003	    2.2932339453385944	    2.6176873076273832	    2.8560026574501229	    3.3486095494864134	    3.8343771518486038	;
  0.045193193127722665	   0.20306196589405009	   0.36243801852520696	   0.49719941308329052	   0.58099408636526650	   0.65330573642944434	   0.75247142521569388	   0.88229034197398137	    1.1396363470720907	    1.3925832480734244	    1.7400306598486259	    2.0408987846670463	    2.3542586880321705	    2.6858485389644495	    3.0359581057113161	    3.3018559825629219	    3.8696162806580485	    4.4344239391781661	;
  0.055440070852056766	   0.22770356260602162	   0.39878550695296222	   0.54992905062627462	   0.64397656184762408	   0.72500101333111844	   0.83581302563643278	   0.98157152401537739	    1.2746159538260033	    1.5383548738645014	    1.9066601338637084	    2.2527954527706209	    2.5918406728107910	    2.9470100314922676	    3.3231510530956538	    3.6085350113741965	    4.2291469498236633	    4.8538703326261157	;
  0.066611794409925956	   0.25318619882378290	   0.43875191440339062	   0.60320205812908745	   0.70671213074070216	   0.79516768450544262	   0.91820259451621133	    1.0820689048935190	    1.4088231436043384	    1.6735809192152757	    2.0814708284475945	    2.4703694131437142	    2.8259713602187411	    3.2045730023162351	    3.6115404434492016	    3.9187862796693147	    4.5958114425947452	    5.2845736475995642	;
  0.090138977001691739	   0.30532962445155964	   0.51625506095108842	   0.69620659332049295	   0.81367356714339778	   0.91864490538782717	    1.0632284644528733	    1.2545034379865827	    1.6175868680663874	    1.9253551478286908	    2.3963109106551701	    2.8189743455131855	    3.2301147329929010	    3.6604241994219677	    4.1166254932910649	    4.4712706977172703	    5.2654234215862532	    6.0787142281866222	;
   0.12498698176768640	   0.36391505715225392	   0.60068953016434690	   0.79607778522811157	   0.92457897228364372	    1.0392922781070608	    1.1990035121459717	    1.4089338536352158	    1.8089041545639402	    2.1719868856064619	    2.6773024672293437	    3.1280100991703264	    3.5948233036405952	    4.0823256740421190	    4.6125167636742814	    5.0252207843521859	    5.9480340239537774	    6.8913148762835164	;
   0.16876679933642608	   0.40907093804279548	   0.65095451607252497	   0.86594033966507544	    1.0055337712590982	    1.1286579184462759	    1.2993503467794922	    1.5240464890780714	    1.9563125698345245	    2.3413531024265204	    2.8752079183344637	    3.3612658165043499	    3.8682462692594726	    4.3905961982259454	    4.9889186516585600	    5.4483047395347270	    6.4690282091149891	    7.5097127740901577	;
   0.26151781648583838	   0.49309330629346210	   0.73382154402949684	   0.96558081696725984	    1.1143423028498833	    1.2458163804740516	    1.4272390780024640	    1.6651129319604674	    2.1274378912012191	    2.5545019836840037	    3.1303704911127355	    3.6684997203824317	    4.2334739129393073	    4.8399552795268219	    5.5058387608065251	    6.0251579415991996	    7.1767296840341972	    8.3456283337596613	;
   0.33046540066447122	   0.55987795173423771	   0.79919928106208604	    1.0339653829707589	    1.1825455292624343	    1.3150881322127006	    1.4994298170300597	    1.7474684934734719	    2.2246475332304945	    2.6708506040736526	    3.2624186958814763	    3.8207062531375020	    4.4209410165635736	    5.0780110693837193	    5.7921095054943015	    6.3452321714165585	    7.5639494335709729	    8.8004295470451641	;
   0.49239483638125264	   0.73092876423971642	   0.96897587563495413	    1.2048975226044329	    1.3558768968102552	    1.4860080968753682	    1.6655623935629389	    1.9228161932527077	    2.4262480466302576	    2.8930123336631604	    3.5234279231267140	    4.1102003771694262	    4.7680846808451083	    5.5124729575862705	    6.3451156116837142	    6.9644648214072840	    8.3057779570632668	    9.6669942862119402	;
   0.62783472334015189	   0.90157470127124462	    1.1782014475480811	    1.4114564089434618	    1.5510674119854493	    1.6767763401291269	    1.8568595133849140	    2.1020389518419349	    2.5913069392963521	    3.0734045486907271	    3.7399252996710430	    4.3641844134988164	    5.0562060875896133	    5.8416222417413906	    6.7666858102123966	    7.4380951504935711	    8.8819040983781576	    10.334795849996283	;
   0.76218803656282785	    1.0701823686170060	    1.3659000705192064	    1.6005619740785697	    1.7463479017938881	    1.8812621442997421	    2.0800377960937309	    2.3244284203008481	    2.7859402428311104	    3.2680895812998787	    3.9832238000847551	    4.6560191869025411	    5.3847688506983928	    6.2240054673598584	    7.1869497463660528	    7.9158133005727995	    9.4682033123813412	    11.006822696293129	;
   0.88644046282532507	    1.2270683602465808	    1.5650479283480376	    1.8532346859779703	    1.9964573552945468	    2.1278216471397262	    2.3293292248021507	    2.5808086835902562	    3.0415575677462736	    3.5238852240854910	    4.2535878765078756	    4.9989699278661677	    5.7837593571061436	    6.6828927490929466	    7.6780658967106419	    8.4447001603459011	    10.090033452767198	    11.704695652081636	;
   0.93470392719207784	    1.2872523816906571	    1.6364530567436950	    1.9247881380143126	    2.0813641614062659	    2.2237575609921665	    2.4291345720512232	    2.6947062515834097	    3.1686467529385096	    3.6573386173967259	    4.3710823655557371	    5.1427434137751060	    5.9528520091931245	    6.8836690256864159	    7.8979546463804029	    8.6784332407463900	    10.354711394867921	    11.997013296437558	;
    1.0478396560049457	    1.4258754354849841	    1.7949789430155474	    2.1084288149816457	    2.2981401873277023	    2.4660411982860837	    2.7118160028245097	    3.0237976013627152	    3.5696314522135588	    4.0937337166118946	    4.7041901692449288	    5.4906371482316558	    6.3914701339812483	    7.4261983348792118	    8.5044483162383067	    9.3165319618603828	    11.048713661773226	    12.749505799660485	;
    1.1467647427464549	    1.5662633236085197	    1.9894725214574422	    2.3844050190559671	    2.6370664941668620	    2.8609257423422343	    3.1743045061529709	    3.5856342288203660	    4.2099712434487708	    4.8162618646410662	    5.1920014628889906	    5.9765382202384068	    6.9578241297743837	    8.0864402886156288	    9.2239407745563611	    10.053837466121651	    11.810955907859675	    13.552751289610043	;
    1.2664956205483044	    1.7731176690161348	    2.2912903992974814	    2.7679515838253952	    3.0572871475722856	    3.3038225632701277	    3.6309307038784295	    4.0263797809002853	    4.6060753333608728	    5.0653397554500659	    5.9947729755049517	    6.8210860994758855	    7.7632262528676259	    8.9620977501078301	    10.083870479736980	    10.943218791390102	    12.723898554566592	    14.510611361848897	;
    1.4592257390876604	    2.0493905448117573	    2.6401264623709886	    3.1580964446264059	    3.4614954123040036	    3.7161845240064051	    4.0507472370397641	    4.4598913181381663	    5.1667701227253957	    5.8433634783304287	    6.8683894617138632	    7.7380302693311656	    8.5923061093928279	    9.7285439881327793	    10.914541301391784	    11.809531280336987	    13.708701502307811	    15.598533327225205	;
    1.6852007667060620	    2.3207331477744089	    2.9525507473553945	    3.5048859437628970	    3.8311607524036360	    4.1073535995087216	    4.4752389804318495	    4.9386279642306414	    5.7954176773019856	    6.6054371037098418	    7.6799298541009611	    8.5911973431974484	    9.5585560754353214	    10.610647581167557	    11.745758021339432	    12.634435528587224	    14.633763258978776	    16.665369877936328	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('FTAG 26781');

% Idle Speed
engine.idle_speed_radps = class_REVS_dynamic_lookup;
engine.idle_speed_radps.axis_1.signal =  'veh_spd_mps'; 
engine.idle_speed_radps.axis_1.breakpoints = [	    0.00000000000000000	    10.000000000000000		]; 
engine.idle_speed_radps.table = [	     60.737457969402662	;     60.737457969402662		]; 

% Pedal Calibration
engine.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;

% Calibration Adjustment Factors
% -- None -- 
